/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.util;

public class RsfHexadecimal {
    private static void test(String[] args) {
        String hex = "1A2B3C4D5E6F7890";
        System.out.println(RsfHexadecimal.buildHexadecimalString(RsfHexadecimal.getBytesFromHexadecimalString(hex)));
    }

    private RsfHexadecimal() {
    }

    public static String buildHexadecimalString(byte[] charbytes) {
        if (charbytes == null) {
            throw new IllegalArgumentException("Null byte array");
        }
        StringBuffer buffer = new StringBuffer();
        String hexdigits = "0123456789ABCDEF";
        for (int i = 0; i < charbytes.length; ++i) {
            buffer.append(hexdigits.charAt((charbytes[i] & 0xFF) >>> 4));
            buffer.append(hexdigits.charAt(charbytes[i] & 0xF));
        }
        return buffer.toString();
    }

    public static byte[] getBytesFromHexadecimalString(String hexString) throws IllegalArgumentException {
        if (hexString == null) {
            throw new IllegalArgumentException("Null hex string");
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("Odd number of charaters in hex string");
        }
        String hexDigits = "0123456789ABCDEF";
        byte[] result = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            int sixteens = hexDigits.indexOf(hexString.charAt(2 * i));
            int ones = hexDigits.indexOf(hexString.charAt(2 * i + 1));
            if (ones == -1 || sixteens == -1) {
                throw new IllegalArgumentException("Non-hexadecimal digits in hex string");
            }
            result[i] = (byte)(sixteens * 16 + ones);
        }
        return result;
    }

    public static String buildHexadecimalString(byte[] charbytes, int start, int length) {
        StringBuffer buffer = new StringBuffer();
        String hexdigits = "0123456789ABCDEF";
        int l = length;
        if (l + start > charbytes.length) {
            l = charbytes.length - start;
        }
        for (int i = 0; i < l; ++i) {
            buffer.append(hexdigits.charAt((charbytes[i + start] & 0xFF) >>> 4));
            buffer.append(hexdigits.charAt(charbytes[i + start] & 0xF));
        }
        return buffer.toString();
    }
}

